package com.agilex.healthcare.directscheduling.domain;


import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 10/2/13
 * Time: 11:39 AM
 * To change this template use File | Settings | File Templates.
 */
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "cancelAppointment", namespace = Namespace.DirectScheduling)
@XmlType(namespace = Namespace.DirectScheduling)
public class CancelAppointment implements Serializable {

    private static final long serialVersionUID = -1387222228696018586L;

    @XmlElement
    private String clinicId;
    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date appointmentTime;
    @XmlElement
    private String cancelCode;
    @XmlElement
    private String cancelReason;
    @XmlElement
    private String remarks;
    @XmlElement
    private String clinicName;
    @XmlElement
    private PatientIdentifier patientIdentifier;

    public String getClinicId() {
        return clinicId;
    }

    public void setClinicId(String clinicId) {
        this.clinicId = clinicId;
    }

    public Date getAppointmentTime() {
        return appointmentTime;
    }

    public void setAppointmentTime(Date appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    public String getCancelCode() {
        return cancelCode;
    }

    public void setCancelCode(String cancelCode) {
        this.cancelCode = cancelCode;
    }

    public String getCancelReason() {
        return cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getClinicName() {
        return clinicName;
    }

    public void setClinicName(String clinicName) {
        this.clinicName = clinicName;
    }

    public PatientIdentifier getPatientIdentifier() {
        return patientIdentifier;
    }

    public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }
}
